/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dan200.computercraft.client.render.ItemMapLikeRenderer;
import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.PrintoutData;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class PrintoutItemRenderer
extends ItemMapLikeRenderer {
    public static final PrintoutItemRenderer INSTANCE = new PrintoutItemRenderer();

    private PrintoutItemRenderer() {
    }

    @Override
    protected void renderItem(PoseStack transform, MultiBufferSource render, ItemStack stack, int light) {
        transform.mulPose(Axis.XP.rotationDegrees(180.0f));
        transform.scale(0.42f, 0.42f, -0.42f);
        transform.translate(-0.5f, -0.48f, 0.0f);
        PrintoutItemRenderer.drawPrintout(transform, render, stack, light);
    }

    public static void onRenderInFrame(PoseStack transform, MultiBufferSource render, ItemFrame frame, ItemStack stack, int packedLight) {
        transform.translate(0.0f, 0.0f, -0.001f);
        transform.mulPose(Axis.ZP.rotationDegrees(180.0f));
        transform.scale(0.95f, 0.95f, -0.95f);
        transform.translate(-0.5f, -0.5f, 0.0f);
        int light = frame.getType() == EntityType.GLOW_ITEM_FRAME ? 15728850 : packedLight;
        PrintoutItemRenderer.drawPrintout(transform, render, stack, light);
    }

    private static void drawPrintout(PoseStack transform, MultiBufferSource render, ItemStack stack, int light) {
        PrintoutData pageData = (PrintoutData)stack.getOrDefault((DataComponentType)ModRegistry.DataComponents.PRINTOUT.get(), (Object)PrintoutData.EMPTY);
        int pages = pageData.pages();
        boolean book = stack.is((Item)ModRegistry.Items.PRINTED_BOOK.get());
        double width = 176.0;
        double height = 211.0;
        if (!book) {
            width += (double)PrintoutRenderer.offsetAt(pages - 1);
        }
        double visualWidth = width;
        double visualHeight = height;
        if (book) {
            visualWidth += (double)(24.0f + 2.0f * PrintoutRenderer.offsetAt(pages));
            visualHeight += 24.0;
        }
        double max = Math.max(visualHeight, visualWidth);
        float scale = (float)(1.0 / max);
        transform.scale(scale, scale, scale);
        transform.translate((max - width) / 2.0, (max - height) / 2.0, 0.0);
        PrintoutRenderer.drawBorder(transform, render, 0.0f, 0.0f, -0.01f, 0, pages, book, light);
        PrintoutRenderer.drawText(transform, render, 13, 11, 0, light, pageData.lines());
    }
}

