/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.core.Logging;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.VarargArguments;
import dan200.computercraft.core.methods.LuaMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.function.ResumableVarArgFunction;

class ResultInterpreterFunction
extends ResumableVarArgFunction<Container> {
    private static final Logger LOG = LoggerFactory.getLogger(ResultInterpreterFunction.class);
    private final CobaltLuaMachine machine;
    private final LuaMethod method;
    private final Object instance;
    private final ILuaContext context;
    private final String funcName;

    ResultInterpreterFunction(CobaltLuaMachine machine, LuaMethod method, Object instance, ILuaContext context, String name) {
        this.machine = machine;
        this.method = method;
        this.instance = instance;
        this.context = context;
        this.funcName = name;
    }

    protected Varargs invoke(LuaState state, DebugFrame debugFrame, Varargs args) throws LuaError, UnwindThrowable {
        MethodResult results;
        try (VarargArguments arguments = VarargArguments.of(args);){
            results = this.method.apply(this.instance, this.context, arguments);
        }
        ILuaCallback callback = results.getCallback();
        Varargs ret = this.machine.toValues(results.getResult());
        if (callback == null) {
            return ret;
        }
        debugFrame.state = new Container(callback, results.getErrorAdjust());
        return (Varargs)LuaThread.yield((LuaState)state, (Varargs)ret);
    }

    public Varargs resume(LuaState state, Container container, Varargs args) throws LuaError, UnwindThrowable {
        MethodResult results;
        Object[] arguments = CobaltLuaMachine.toObjects(args);
        try {
            results = container.callback.resume(arguments);
        }
        catch (LuaException e) {
            throw ResultInterpreterFunction.wrap(e, container.errorAdjust);
        }
        catch (Throwable t) {
            LOG.error(Logging.JAVA_ERROR, "Error calling {} on {}", new Object[]{this.funcName, container.callback, t});
            throw new LuaError("Java Exception Thrown: " + String.valueOf(t), 0);
        }
        Varargs ret = this.machine.toValues(results.getResult());
        ILuaCallback callback = results.getCallback();
        if (callback == null) {
            return ret;
        }
        container.callback = callback;
        return (Varargs)LuaThread.yield((LuaState)state, (Varargs)ret);
    }

    public static LuaError wrap(LuaException exception, int adjust) {
        if (!exception.hasLevel() && adjust == 0) {
            return new LuaError(exception.getMessage());
        }
        int level = exception.getLevel();
        return new LuaError(exception.getMessage(), level <= 0 ? level : level + adjust);
    }

    static class Container {
        ILuaCallback callback;
        final int errorAdjust;

        Container(ILuaCallback callback, int errorAdjust) {
            this.callback = callback;
            this.errorAdjust = errorAdjust;
        }
    }
}

