/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.integration;

import com.google.auto.service.AutoService;
import com.mojang.blaze3d.vertex.VertexFormat;
import dan200.computercraft.client.integration.ShaderMod;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import dan200.computercraft.shared.platform.PlatformHelper;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.IntFunction;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.api.v0.IrisTextVertexSink;
import net.minecraft.util.FastColor;

@AutoService(value={ShaderMod.Provider.class})
public class IrisShaderMod
implements ShaderMod.Provider {
    @Override
    public Optional<ShaderMod> get() {
        return PlatformHelper.get().isModLoaded("iris") ? Optional.of(new Impl()) : Optional.empty();
    }

    private static final class Impl
    extends ShaderMod {
        private Impl() {
        }

        @Override
        public boolean isRenderingShadowPass() {
            return IrisApi.getInstance().isRenderingShadowPass();
        }

        @Override
        public DirectFixedWidthFontRenderer.QuadEmitter getQuadEmitter(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
            return IrisApi.getInstance().getMinorApiRevision() >= 1 ? new IrisQuadEmitter(vertexCount, makeBuffer) : super.getQuadEmitter(vertexCount, makeBuffer);
        }

        private static final class IrisQuadEmitter
        implements DirectFixedWidthFontRenderer.QuadEmitter {
            private final IrisTextVertexSink sink;

            private IrisQuadEmitter(int vertexCount, IntFunction<ByteBuffer> makeBuffer) {
                this.sink = IrisApi.getInstance().createTextVertexSink(vertexCount, makeBuffer);
            }

            @Override
            public VertexFormat format() {
                return this.sink.getUnderlyingVertexFormat();
            }

            @Override
            public ByteBuffer buffer() {
                return this.sink.getUnderlyingByteBuffer();
            }

            @Override
            public void quad(float x1, float y1, float x2, float y2, float z, int colour, float u1, float v1, float u2, float v2) {
                this.sink.quad(x1, y1, x2, y2, z, FastColor.ABGR32.fromArgb32((int)colour), u1, v1, u2, v2, 0xF000F0);
            }
        }
    }
}

