/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class DataComponentUtil {
    public static @Nullable String getCustomName(DataComponentHolder holder) {
        return DataComponentUtil.getCustomName((Component)holder.get(DataComponents.CUSTOM_NAME));
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String getCustomName(@Nullable Component name) {
        return name != null ? name.getString() : null;
    }

    public static void setCustomName(ItemStack stack, @Nullable String label) {
        stack.set(DataComponents.CUSTOM_NAME, (Object)(label == null ? null : Component.literal((String)label)));
    }

    private static <T> ItemStack set(ItemStack stack, DataComponentType<T> type, @Nullable T value) {
        stack.set(type, value);
        return stack;
    }

    public static <T> ItemStack createResult(ItemStack stack, DataComponentType<T> type, @Nullable T value) {
        return DataComponentUtil.set(stack.copyWithCount(1), type, value);
    }

    public static <T> ItemStack createStack(ItemLike item, DataComponentType<T> type, @Nullable T value) {
        return DataComponentUtil.set(new ItemStack(item), type, value);
    }

    public static <T> boolean isPresent(DataComponentPatch patch, DataComponentType<T> component, Predicate<T> check) {
        Optional value = patch.get(component);
        return value != null && value.isPresent() && check.test(value.get());
    }
}

